/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.GuiModuleScreen;
import mekanism.client.gui.element.scroll.GuiModuleScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiMekaSuitHelmetOptions;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiModuleTweaker
extends GuiMekanism<ModuleTweakerContainer> {
    private GuiModuleScrollList scrollList;
    private GuiModuleScreen moduleScreen;
    private TranslationButton optionsButton;
    private int selected = -1;

    public GuiModuleTweaker(ModuleTweakerContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.f_97726_ = 248;
        this.f_97727_ += 20;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.moduleScreen = this.addRenderableWidget(new GuiModuleScreen(this, 138, 20, () -> ((Slot)((ModuleTweakerContainer)this.f_97732_).f_38839_.get(this.selected)).getSlotIndex()));
        this.scrollList = this.addRenderableWidget(new GuiModuleScrollList(this, 30, 20, 108, 116, () -> this.getStack(this.selected), this::onModuleSelected));
        this.addRenderableWidget(new GuiElementHolder(this, 30, 136, 108, 18));
        this.optionsButton = this.addRenderableWidget(new TranslationButton(this, 31, 137, 106, 16, MekanismLang.BUTTON_OPTIONS, this::openOptions));
        this.optionsButton.f_93623_ = false;
        int size = ((ModuleTweakerContainer)this.f_97732_).f_38839_.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)((ModuleTweakerContainer)this.f_97732_).f_38839_.get(i);
            int index = i;
            if (this.selected == -1 && this.isValidItem(index)) {
                this.select(index);
            }
            this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, slot.f_40220_ - 1, slot.f_40221_ - 1).click((e, x, y) -> this.select(index)).overlayColor(this.isValidItem(index) ? null : () -> -869059789).with(() -> index == this.selected ? SlotOverlay.SELECT : null));
        }
    }

    private void onModuleSelected(Module<?> module) {
        this.moduleScreen.setModule(module);
    }

    private void openOptions() {
        this.addWindow(new GuiMekaSuitHelmetOptions(this, this.getWidth() / 2 - 70, this.getHeight() / 2 - 45));
    }

    @Override
    public boolean m_7933_(int key, int i, int j) {
        if (super.m_7933_(key, i, j)) {
            return true;
        }
        if (this.selected != -1 && (this.isPreviousButton(key) || this.isNextButton(key))) {
            int curIndex = -1;
            IntArrayList selectable = new IntArrayList();
            int slots = ((ModuleTweakerContainer)this.f_97732_).f_38839_.size();
            for (int index = 0; index < slots; ++index) {
                if (!this.isValidItem(index)) continue;
                selectable.add(index);
                if (index != this.selected) continue;
                curIndex = selectable.size() - 1;
            }
            int targetIndex = this.isPreviousButton(key) ? (curIndex == 0 ? selectable.size() - 1 : curIndex - 1) : curIndex + 1;
            this.select(selectable.getInt(targetIndex % selectable.size()));
            return true;
        }
        return false;
    }

    private boolean isPreviousButton(int key) {
        return key == 265 || key == 263;
    }

    private boolean isNextButton(int key) {
        return key == 264 || key == 262;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.moduleScreen.m_7691_(mouseX, mouseY);
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void select(int index) {
        if (this.isValidItem(index)) {
            this.selected = index;
            ItemStack stack = this.getStack(index);
            this.scrollList.updateList(stack, true);
            this.optionsButton.f_93623_ = stack.m_41720_() == MekanismItems.MEKASUIT_HELMET.get();
        }
    }

    private boolean isValidItem(int index) {
        return ModuleTweakerContainer.isTweakableItem(this.getStack(index));
    }

    private ItemStack getStack(int index) {
        if (index == -1) {
            return ItemStack.f_41583_;
        }
        return ((Slot)((ModuleTweakerContainer)this.f_97732_).f_38839_.get(index)).m_7993_();
    }
}

